package edu.uky.ai.lp.logic;

/**
 * The superclass of all logical expression representing specific things in the
 * universe.
 * 
 * @author Stephen G. Ware
 */
public abstract class Term implements Formula {
	
	/** The unique name of the term */
	public final String name;
	
	/**
	 * Constructs a new term with a given name.
	 * 
	 * @param name the name of the term
	 */
	public Term(String name) {
		this.name = name;
	}
	
	@Override
	public boolean equals(Object other) {
		if(other instanceof Term)
			return name.equals(((Term) other).name);
		else
			return false;
	}
	
	@Override
	public int hashCode() {
		return name.hashCode();
	}
	
	@Override
	public String toString() {
		return name;
	}
	
	@Override
	public abstract Term substitute(Unifier unifier);
}
